/*
 * Processor Status Word bits used by monitor
 */
#define	DB_PSW_INTPRI	0x0700
#define	DB_PSW_MASTER	0x1000
#define	DB_PSW_SUPV	0x2000
#define	DB_PSW_FLOTRACE	0x4000
#define	DB_PSW_TRACE	0x8000

/*
 * Register model for 68000 family
 */
#define	DB_NREGS	26
#define	DB_NREGS_USER	18
#define	DB_NREGS_68000	20
#define	DB_NREGS_68010	23
#define	DB_NREGS_68020	DB_NREGS
#define	DB_REG_D(i)	(i)	/* 0 <= i <= 7 */
#define	DB_REG_A(i)	(8+(i))	/* 0 <= i <= 7 */
#define	DB_REG_FP	14
#define	DB_REG_SP	15	/* SP depends on the mode */
#define	DB_REG_PS	16
#define	DB_REG_PC	17
#define	DB_REG_USP	18
#define	DB_REG_ISP	19
#define	DB_REG_VBR	20	/* Start 68010 */
#define	DB_REG_SFC	21
#define	DB_REG_DFC	22
#define	DB_REG_MSP	23	/* Start 68020 */
#define	DB_REG_CACR	24
#define	DB_REG_CAAR	25

#ifndef LOCORE
struct DebugRegs {
	long	r[DB_NREGS];
};
#endif /* !LOCORE */

/*
 * 68000 family traps used by monitor
 */
#define	DB_TRAP_BUS_ERROR	0x008
#define	DB_TRAP_TRACE		0x024
#define	DB_TRAP_BKPT		0x0BC
